

#include "UnityNP.h"
#include "Mutex.h"

#include <list>

namespace UnityPlugin
{


	class NpAsyncRequests
	{


		static int s_RequestRef;


		struct UnityNpRequest
		{
			UnityNpRequest()
			{
				memset(this,0x00, sizeof(UnityNpRequest));
				m_requestId = -1;
				m_requestType = TypeInvalid;
			}

			enum RequestType
			{
				TypeCheckPlus,
				TypeAccountLanguage,
				TypeParentalControlInfo,
				TypeNPAvailabilty,
				TypeSetGamePresenceOnline,
				TypeInvalid
			} ;

			int m_requestId;
			RequestType m_requestType;

			union
			{
				struct // TypeCheckPlus
				{
					SceNpCheckPlusParameter m_CheckPlusParameter;
					SceNpCheckPlusResult m_CheckPlusResult;
				};

				struct // TypeAccountLanguage
				{
					SceNpOnlineId  m_ALNpOnlineId;
					SceNpLanguageCode m_LanguageCode;
				};
				struct // TypeParentalControlInfo
				{
					SceNpOnlineId  m_PCNpOnlineId;
					int8_t m_Age;
					SceNpParentalControlInfo m_ParentalControlInfo;
				};

				struct // TypeSetGamePresenceOnline & TypeNPAvailabilty
				{
					SceNpOnlineId m_NpOnlineId;		// does this return any data
				};

				

			};


		};

		std::map<int, UnityNpRequest *> m_RequestList;



	public:
		NpAsyncRequests();

		struct NpAsyncRequests::UnityNpRequest * CreateRequest();
		void DeleteRequest(NpAsyncRequests::UnityNpRequest *request);
		void Update();

		ErrorCode CheckPlus(SceUserServiceUserId userId, uint64_t features);
		ErrorCode NotifyPlusFeature(SceUserServiceUserId userId, uint64_t features);
		ErrorCode GetAccountLanguage(const char *onlineId);
		ErrorCode GetParentalControlInfo(const char *onlineId);
		ErrorCode CheckNpAvailability(const char *onlineId);
		ErrorCode SetGamePresenceOnline(const char *onlineId);


	private:
		struct Query
		{
			Query() :
				userId(SCE_USER_SERVICE_USER_ID_INVALID),
				features(0UL),
				requestId(0),
				requestResult(-1)
			{
				memset(&checkPlusResult, 0, sizeof(checkPlusResult));
			}

			SceUserServiceUserId	userId;
			uint64_t				features;			// SCE_NP_PLUS_FEATURE_REALTIME_MULTIPLAY | SCE_NP_PLUS_FEATURE_ASYNC_MULTIPLAY
			SceNpCheckPlusResult	checkPlusResult;
			int						requestId;
			int						requestResult;
		};


//		Query	m_Query;
//		enum AsyncState m_State;

	};

	extern NpAsyncRequests gRequests;
}
